/*
 * Decompiled with CFR 0.152.
 */
package net.but2002.minecraft.BukkitSpeak;

import java.util.HashMap;
import java.util.logging.Level;
import net.but2002.minecraft.BukkitSpeak.BukkitSpeak;
import org.bukkit.util.config.Configuration;

public class StringManager {
    private HashMap<String, String> strings = new HashMap();
    private String ip;
    private String serverAdmin;
    private String serverPass;
    private int queryPort;
    private int serverPort;
    public static final String CONFIG_IP = "ip";
    public static final String CONFIG_QUERYPORT = "queryPort";
    public static final String CONFIG_SERVERPORT = "serverPort";
    public static final String CONFIG_SERVERADMIN = "serverAdmin";
    public static final String CONFIG_SERVERPASS = "serverPass";
    public static final String[] MESSAGES = new String[]{"msg_join", "msg_quit", "msg_servermsg"};
    private BukkitSpeak plugin;

    public StringManager(BukkitSpeak plugin) {
        this.plugin = plugin;
        Configuration config = plugin.getConfiguration();
        boolean error = false;
        this.ip = config.getString(CONFIG_IP);
        if (this.ip == null) {
            config.setProperty(CONFIG_IP, (Object)"1.2.3.4");
            this.logConfigError("IP");
            error = true;
        }
        String queryPort = config.getString(CONFIG_QUERYPORT);
        try {
            this.setQueryPort(Integer.parseInt(queryPort));
        }
        catch (Exception e) {
            config.setProperty(CONFIG_QUERYPORT, (Object)"10011");
            this.logConfigError(e.toString());
            error = true;
        }
        String serverPort = config.getString(CONFIG_SERVERPORT);
        try {
            this.setServerPort(Integer.parseInt(serverPort));
        }
        catch (Exception e) {
            config.setProperty(CONFIG_SERVERPORT, (Object)"9987");
            this.logConfigError(e.toString());
            error = true;
        }
        String serverAdmin = config.getString(CONFIG_SERVERADMIN);
        try {
            this.setServerAdmin(serverAdmin);
        }
        catch (Exception e) {
            config.setProperty(CONFIG_SERVERADMIN, (Object)"serveradmin");
            this.logConfigError(e.toString());
            error = true;
        }
        String serverPass = config.getString(CONFIG_SERVERPASS);
        try {
            this.setServerPass(serverPass);
        }
        catch (Exception e) {
            config.setProperty(CONFIG_SERVERPASS, (Object)"serverpass");
            this.logConfigError(e.toString());
            error = true;
        }
        for (String currentNode : MESSAGES) {
            String currentValue = config.getString(currentNode);
            if (currentValue == null) {
                config.setProperty(currentNode, (Object)this.getDefaultMessage(currentNode));
                this.logConfigError(currentNode);
                error = true;
                continue;
            }
            this.strings.put(currentNode, currentValue);
        }
        if (error) {
            config.save();
            plugin.disable();
        }
    }

    private void logConfigError(String message) {
        this.plugin.getLogger().log(Level.SEVERE, "[" + this.plugin.getDescription().getName() + "] Error while parsing " + message);
    }

    private String getDefaultMessage(String node) {
        if (node.equals("msg_join")) {
            return "%name% has joined TS";
        }
        if (node.equals("msg_quit")) {
            return "%name% has quit TS";
        }
        if (node.equals("msg_servermsg")) {
            return "[TS][Server][%client_nickname%] %msg%";
        }
        return "FIXME";
    }

    public String getMessage(String key) {
        return this.strings.get(key);
    }

    public String getIp() {
        return this.ip;
    }

    public void setQueryPort(int queryPort) {
        this.queryPort = queryPort;
    }

    public int getQueryPort() {
        return this.queryPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerAdmin(String serverAdmin) {
        this.serverAdmin = serverAdmin;
    }

    public void setServerPass(String serverPass) {
        this.serverPass = serverPass;
    }

    public String getServerAdmin() {
        return this.serverAdmin;
    }

    public String getServerPass() {
        return this.serverPass;
    }
}

