/*
 * Decompiled with CFR 0.152.
 */
package net.but2002.minecraft.BukkitSpeak;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.logging.Level;
import net.but2002.minecraft.BukkitSpeak.BukkitSpeak;
import net.but2002.minecraft.BukkitSpeak.StringManager;
import net.but2002.minecraft.BukkitSpeak.TeamspeakKeepAlive;
import net.but2002.minecraft.BukkitSpeak.TeamspeakUser;
import net.but2002.minecraft.BukkitSpeak.teamspeakEvent.EnterEvent;
import net.but2002.minecraft.BukkitSpeak.teamspeakEvent.LeaveEvent;
import net.but2002.minecraft.BukkitSpeak.teamspeakEvent.ServerMessageEvent;

public class TeamspeakHandler
implements Runnable {
    BukkitSpeak plugin;
    StringManager stringManager;
    boolean kill = false;
    private HashMap<Integer, TeamspeakUser> users = new HashMap();
    private TeamspeakKeepAlive keepAliveThread;
    Socket socket;
    PrintWriter out;
    BufferedReader in;

    public TeamspeakHandler(BukkitSpeak plugin) {
        this.plugin = plugin;
        this.stringManager = plugin.getStringManager();
        this.connect();
    }

    @Override
    public void run() {
        try {
            while (!this.kill) {
                String line;
                if (this.socket.isClosed()) {
                    this.connect();
                }
                if ((line = this.in.readLine()) != null) {
                    this.handleMessage(line);
                }
                Thread.sleep(500L);
            }
            this.in.close();
            this.out.close();
            this.socket.close();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, e.toString());
            e.printStackTrace();
        }
    }

    public void connect() {
        try {
            this.socket = new Socket(InetAddress.getByName(this.stringManager.getIp()), this.stringManager.getQueryPort());
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out.println("login " + this.stringManager.getServerAdmin() + " " + this.stringManager.getServerPass());
            this.out.println("use port=" + this.stringManager.getServerPort());
            this.out.println("servernotifyregister event=server");
            this.out.println("servernotifyregister event=textserver");
            this.socket.setKeepAlive(true);
            if (this.keepAliveThread != null) {
                this.keepAliveThread.kill();
            }
            this.keepAliveThread = new TeamspeakKeepAlive(this.out);
            this.keepAliveThread.start();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, e.toString());
            e.printStackTrace();
        }
    }

    public void handleMessage(String message) {
        String command = message.split(" ")[0];
        message = message.replaceFirst("\\S* ", "");
        if (command.equals("notifycliententerview")) {
            TeamspeakUser user = new EnterEvent(this.plugin, message).getUser();
            this.users.put(user.getID(), user);
        }
        if (command.equals("notifyclientleftview")) {
            new LeaveEvent(this.plugin, message);
        }
        if (command.equals("notifytextmessage")) {
            new ServerMessageEvent(this.plugin, message);
        }
    }

    public void kill() {
        this.kill = true;
    }

    public TeamspeakUser getUserByID(int id) {
        return this.users.get(id);
    }

    public TeamspeakUser getUserByName(String name) {
        TeamspeakUser[] users;
        for (TeamspeakUser currentUser : users = this.users.values().toArray(new TeamspeakUser[this.users.values().size()])) {
            if (!name.equals(currentUser.getName())) continue;
            return currentUser;
        }
        return null;
    }
}

